# ##########################################################################
# Programme Python.

# #####
# IMPORTATION DES MODULES
# #####

import numpy as np
import matplotlib.pyplot as plt
from tkinter import *
from tkinter.filedialog import *

# le fichier "donnees.py" est à mettre dans le même dossier que le fichier "badminton.py"

from donnees import Donnees


# Initialisation des tableaux contenant x,y,t , la norme de V et ses coordonées
x=np.array([])
y=np.array([])
t=np.array([])
V=np.array([])
Vx=np.array([])
Vy=np.array([])


t, x, y = Donnees('avimeca')
Nbre_Mesures=len(x)

# #####
# Calcul de la vitesse par la méthode centrée
# #####

for n in range(1,Nbre_Mesures-1):
    # pour chaque mesure n, on ajoute au tableau Vx la coordonnée de V suivant X
    Vx=np.append(Vx,(x[n+1]-x[n-1])/(t[n+1]-t[n-1]))
    Vy=np.append(Vy,(y[n+1]-y[n-1])/(t[n+1]-t[n-1]))
    # On créée le tableau V, norme de la vitesse
    V=np.sqrt(Vx**2+Vy**2)

# #####
# Modification des listes x, y et t pour que le nombre de points soit le même que V
# #####

# on enlève le dernier élément de x,y et t
x=np.delete(x,len(x)-1)
y=np.delete(y,len(y)-1)
t=np.delete(t,len(t)-1)

# et le premier:
x=np.delete(x,0)
y=np.delete(y,0)
t=np.delete(t,0)


""" ###########################################
Travail à réaliser par le candidat
################################################# """

""" TRAVAIL 1:  masse  et accélération de la pesanteur
 Rentrer ci-dessous les valeurs de m et g dans les unités du système international"""





""" FIN DU TRAVAIL 1 """

# #####################################
# Calculs des grandeurs
# #####################################
"""TRAVAIL 2:
Taper ci-dessous le code Python permettant de calculer les grandeurs utiles à la démarche.
Grandeurs disponibles renseignées dans un tableau "np.array" :
    - t  : date en secondes.
    - x  : abscisse du système à la date t en mètres.
    - y  : ordonnée du système à la date t en mètres.
    - V  : norme du vecteur vitesse à la date t
Inutile ici de faire une boucle for, simplement entrer les expressions des grandeurs"""





""" FIN DU TRAVAIL 2 """

""" TRAVAIL 3:
code Python permettant de tracer les 3 énergies en fonction du temps, on choisira 3 couleurs
différentes pour les courbes.
"""






""" FIN DU TRAVAIL 3 """

""" TRAVAIL 4:
taper, à la place des points entre guillemets, les légendes pour les axes,
le titre du graphique """

plt.title("...................")
plt.xlabel("..................")
plt.ylabel("..................")


""" FIN DU TRAVAIL 4 """
""" ###########################################
Fin du Travail à réaliser par le candidat
################################################# """

# On affiche une grille
plt.grid()
# On affiche le commentaire
plt.legend(bbox_to_anchor=(1.05, 1),loc='upper left',borderaxespad=0.)
# affichage de la figure bien adapté à la fenêtre la fenêtre
plt.tight_layout()
# on affiche la fenêtre

plt.show()

