# Estimation expérimentale de la capacité thermique du calorimètre et de l'incertitude associée à cette mesure.
# importation de la bibliothèque numpy
import numpy as np
N=100000 #nombre d'essais pour la simulation
# valeurs expérimentales (valeurs à reporter à partir des mesures expérimentales)
m1=  #exprimée en gramme
T1=  #exprimée en degré celsius
m2=  #exprimée en gramme
T2=  #exprimée en degré celsius
Tf=  #exprimée en degré celsius
u_T1= #u(T1)
u_T2= #u(T2)
u_Tf= #u(Tf)

# creation d'un liste
capacite=[]
variation_eau_chaude_sim=[]
# Algorithme de Monte Carlo
for k in range(N):
    T1_sim=np.random.uniform(T1-u_T1*np.sqrt(3),T1+u_T1*np.sqrt(3))
    T2_sim=np.random.uniform(T2-u_T2*np.sqrt(3),T2+u_T2*np.sqrt(3))
    Tf_sim=np.random.uniform(Tf-u_Tf*np.sqrt(3),Tf+u_Tf*np.sqrt(3))
    variation_eau_chaude=Tf_sim-T2_sim
    variation_eau_froide=Tf_sim-T1_sim
    capacite.append(-(m1*4.18*variation_eau_froide+m2*4.18*variation_eau_chaude)/variation_eau_froide)
# Calcul de la capacité thermique du calorimètre
capa_calculee=sum(capacite)/N
# Calcul de l'incertitude type du calorimètre
ucapa_calculee=int(np.floor(np.std(capacite,ddof=1))+1)
# Affichage des résultats
print("la valeur de la capacité thermique de calorimètre: C =",capa_calculee,'J/K')
print("incertitude-type de la capacité thermique du calorimètre = ",ucapa_calculee,'J/K')