#!/usr/bin/env python
# -*- coding: utf-8 -*-
import numpy as np
import matplotlib.pyplot as plt
d_A,d_B , g = ...,...,9.81 #d_A:diamètre de la bouteille en mm, d_B:diamètre trou en mm ; A REMPLACER
hi  = 0.15 #hauteur initiale en mètre


# REMPLACER CI-DESSOUS les ... par les temps 
# intermédiaires mesurés en seconde

mesures = np.array([[15,0] , [14, ... ], [13, ... ] , [12, ... ] , [11, ... ], [10, ... ], [9, ... ] , [8, ... ],
                    [7, ... ],[6, ... ], [5, ... ]])

# Extraction du temps et hauteur en mètre depuis mesures
t , h = mesures[:,1],mesures[:,0]*0.01
# Calcul racine de h(t) à partir de Bernouilli
racine_h_bernouilli = np.sqrt(hi) - ((d_B/d_A)**2)*2.21*t
# Modélisation affine des mesures
modele = np.polyfit(t,np.sqrt(h) , 1)
coefficient_directeur = modele[0]
ordonnee_a_l_origine = modele[1]
print(f"Equation de la droite: \n racine(h)= {coefficient_directeur:.2e}*t+{ordonnee_a_l_origine:.2f}")

# UNIQUEMENT POUR LA PARTIE 3 "Détermination du coefficient C"
# REMPLACER CI-DESSOUS LA VALEUR de C PAR CELLE QUE
# VOUS AVEZ CALCULé. SINON LAISSER C = 0

C = 0

# Calcul racine de h(t) en utilisant C
racine_h_modele_corr = np.sqrt(hi) - C*((d_B/d_A)**2)*2.21*t
# Représentations Graphiques
plt.clf()
plt.title(r"Evolution temporelle de $\sqrt{h}$")
plt.plot(t,np.sqrt(h),'ko', label='Expérience')
plt.plot(t,racine_h_bernouilli,'g:',label="Relation de Bernouilli")
if C !=0:
    plt.plot(t,racine_h_modele_corr,'b-',label=f"Modèle corrigé avec un coeffficient  C={C:.3f}")
plt.ylabel(r'$\sqrt{h}$ en $m^{\frac{1}{2}}$')
plt.xlabel('t en s')
plt.legend()
plt.grid()
plt.show()