#!/usr/bin/env python
# -*- coding: utf-8 -*-
import numpy as np
import matplotlib.pyplot as plt
d_A,d_B , g =...,...,9.81 #d_A:diamètre de la bouteille en mm, d_B:diamètre trou en mm ; A REMPLACER
hi  = 0.15 #hauteur initiale en mètre

# REMPLACER CI-DESSOUS les ... par les temps
# intermédiaires mesurés en seconde

mesures = np.array([[15,...] , [14,...], [13,...] , [12,...] , [11,...], [10,...], [9,...] , [8,...],
                    [7,...],[6,...], [5,...])

# Extraction du temps et hauteur en mètre depuis mesures
t , h = mesures[:,1],mesures[:,0]*0.01


# Modélisation affine des mesures expérimentales
modele = np.polyfit(t,np.sqrt(h) , 1)
a = modele[0] # a : coefficient directeur de la droite
b = modele[1] # b : ordonnée à l'origine de la droite

print(f"Modélisation : \n Equation de la droite : racine(h)= {a:.2e}*t+{b:.2f}")


racine_h_modele=a*t+b
"""
# Calcul de la valeur de C
 C=.../(((d_B/d_A)**2)*2.21) # COMPLETER l'expression en remplacant les ...
print("Valeur de C associée au modèle :",round(C,2))
"""

# Calcul racine de h(t) à partir de Bernouilli
racine_h_bernouilli = np.sqrt(hi) - ((d_B/d_A)**2)*2.21*t

# Représentations Graphiques

plt.clf()
plt.title(r"Evolution temporelle de $\sqrt{h}$")
plt.plot(t,np.sqrt(h),'ko', label='Valeurs mesurées')
plt.plot(t,racine_h_modele,'b-',label="modélisation affine")
plt.plot(t,racine_h_bernouilli,'g-',label="Relation de Bernouilli")
plt.xlabel('t en s')
plt.legend()
plt.grid()
plt.show()