/* Modélisation d'un générateur d'impulsions */

const int Te = 10; // Période d'echantillonnage en millisecondes
const int duree = 5; // Durée de l'acquisition en seconde

int Uc_NUM;  // Valeur numérique de la tension Uc aux bornes du condensateur 
float Uc;    // Valeur analogique de Uc

unsigned long tempsZero;
unsigned long temps;

void setup()
{
  Serial.begin(9600);
  Serial.print("t");   // Inscrit dans le moniteur série l'intitulé des colonnes
  Serial.print('\t'); // Insère une tabulation
  Serial.println("Uc"); 
  Serial.print("s");  
  Serial.print('\t');
  Serial.println("V");
  pinMode(A0, INPUT);
  tempsZero = millis(); // Temps initial exprimé en millisecondes
  temps = 0; // Initialise la variable temps
}
   
void loop()
{
  
  while (temps/1000.0<=duree) // L'acquisition se poursuit tant que le temps écoulé est < ou = à la durée d'acquisition
  {

    //=================== CHARGE DU CONDENSATEUR ===================
    pinMode(4, INPUT);   // La branche contenant "R" est "déconnectée"
    pinMode(3, OUTPUT); // La branche contenant "r" est "connectée"
    digitalWrite(3, HIGH); // La broche 3 est mise à 5V et "C" se charge à travers "r"
    do
    {
      temps = millis()-tempsZero; // Calcule le temps écoulé, en millisecondes
      Uc_NUM = analogRead(A0);  // Lis la valeur numérique de Uc sur A0
      Uc = Uc_NUM * 5.0 / 1023 ;  // Conversion de Uc_NUM en Uc (10 bits soit 1024 valeurs sur 5V)
      Serial.print(temps/1000.0); // Affiche la date t en secondes
      Serial.print('\t');  // Insère une tabulation
      Serial.println(Uc); // Affiche la tension Uc en V
      delay(Te); // Fait une pause de durée Te
    }
    while (Uc <= 4.9); // Avec ce paramétrage et compte-tenu de l'échantillonnage, l'étape de charge se termine effectivement à 5V
    //============== FIN DE LA CHARGE DU CONDENSATEUR ==============  
    
          
    //================== DÉCHARGE DU CONDENSATEUR ==================
    pinMode(3, INPUT); //  La branche contenant "r" est "déconnectée"
    pinMode(4, OUTPUT); // La branche contenant "R" est "connectée" 
    digitalWrite(4, LOW);   // La broche 4 est mise à 0V et "C" se décharge à travers "R"
    do
    {
      temps = millis()-tempsZero; // Calcule le temps écoulé, en millisecondes
      Uc_NUM = analogRead(A0); // Calcule le temps écoulé, en millisecondes
      Uc = Uc_NUM * 5.0 / 1023.0;  // Conversion de Uc_NUM en Uc (10 bits soit 1024 valeurs sur 5V)
      Serial.print(temps/1000.0);  // Affiche la date t en secondes
      Serial.print('\t'); // Insère une tabulation
      Serial.println(Uc);  // Affiche la tension Uc en V
      delay(Te);  // Fait une pause de durée Te
    }
    while (Uc >= 3.0); // L'étape de décharge se termine lorsque Uc atteint la valeur en Volt indiquée après les symboles >=
    //============== FIN DE LA DÉCHARGE DU CONDENSATEUR ============
  
  }

}
