import numpy as np
from matplotlib import pyplot as plt

#PARAMETRES EXPERIMENTAUX

#Concentration de la solution titrée en mol/L
C1 =
#Volume de solution titrée en mL
V1 =
#Concentration de la solution titrante mol/L
C2 =
#Volume de solution titrante versé à l'équivalence en mL
V2eqv =

#DEFINITION DES LISTES

#Volume de solution titrante versée en mL
V2=[]
#Quantité de matière d'ions hypochlorite en mol
n1=[]
#Quantité de matière d'ions iodure en mol
n2=[]
#Quantité de matière d'ions sodium en mol
n3=[]
#Quantité de matière d'ions potassium en mol
n4=[]
#Quantité de matière d'ions chlorure en mol
n5=[]
#Quantité de matière d'ions iodate
n6=[]
#Conductivité
sigma=[]


#Valeurs des conductivités molaires ioniques en mS.m².mol-1
#ions hypochlorite
l1 = 5.2
#ions iodure
l2 = 7.68
#ions sodium
l3 = 5.01
#ions potassium
l4 = 7.35
#ions chlorure
l5 = 7.631
#ions iodate
l6 = 4.05

for i in range (0,25):

    V2.append(i)

    if V2[i]<V2eqv:
       #Si la condition après if est vérifiée les lignes suivantes sont exécutées

        n1.append(C1*V1/1000-3*C2*V2[i]/1000)
        #On ajoute la valeur indiquée dans la liste n1
        n2.append(0)
        #On ajoute la valeur indiquée dans la liste n2
        n3.append(C1*V1/1000)
        n4.append(C2*V2[i]/1000)
        n5.append(3*C2*V2[i]/1000)
        n6.append(C2*V2[i]/1000)
        sigma.append((l1*n1[i]+l2*n2[i]+l3*n3[i]+l4*n4[i]+l5*n5[i]+l6*n6[i])/(0.150))

    else :
        #Si la condition après if n'est pas vérifiée les lignes suivantes sont exécutées

        n2.append(C2*V2[i]/1000-C1*V1/(3*1000))
        n1.append(0)
        n3.append(C1*V1/1000)
        n4.append(C2*V2[i]/1000)
        n5.append(3*C2*V2eqv/1000)
        n6.append(C2*V2eqv/1000)
        sigma.append((l1*n1[i]+l2*n2[i]+l3*n3[i]+l4*n4[i]+l5*n5[i]+l6*n6[i])/(0.150))


#TRACE DU GRAPHIQUE
plt.title("évolution de la conductivité au cours du titrage")
plt.xlabel("Volume de solution titrante versée en mL")
plt.ylabel("sigma en S.m-1")
plt.grid(True)
plt.plot(V2,sigma,label="sigma")
plt.legend()
plt.show()
print(V2eqv)



