# -*- coding: utf-8 -*-
"""
Incertitude-type u(f') - Méthode de Bessel
"""

import numpy as np

###############################################################################
####        Partie à modifier                                              ####
###############################################################################
d =          # A MODIFIER : la plus petite graduation (en centimètre)
delta_d =    # A MODIFIER : variation de la position de la lentille pour avoir une image nette

u_d = d/np.sqrt(6) # incertitude-type associée à d (en centimètre)
u_delta_d =  # A MODIFIER :incertitude-type associée à delta_d (en centimètre)

D =  # A MODIFIER : mesure de D (en centimètre)
uD =  # A MODIFIER : incertitude-type sur la mesure de D (en centimètre)

x1=  # A MODIFIER : mesure de la position 1 (en centimètre)
x2=  # A MODIFIER : mesure de la position 2 (en centimètre)
L = np.abs(x1-x2) # longueur L (en centimètre)

uL= np.sqrt(2)*np.sqrt((u_d)**2 + (u_delta_d)**2) # incertitude-type sur la mesure de L en cm

###############################################################################
####        Ne pas modifier la suite de ce programme                       ####
###############################################################################

uf=np.sqrt(((D**2+L**2)/(4*D**2)*uD)**2+(L*uL/(2*D))**2)

print("Incertitude-type composée sur la distance focale f' (cm) : u(f')=",uf)