# PROGRAMME DE COMMANDE DU MICROCONTROLEUR

from microbit import *
Te = 1000 # Période d'echantillonnage en millisecondes

# Initialisation des variables
A0, A1, B0, B1 = ' ', ' ', ' ', ' ' # Initialement la surface n'est pas en contact du doigt

while True:
    # ================ MESURE ET AFFICHAGE DE LA TENSION ================
    Uc_NUM0 = pin0.read_analog() # Lis la valeur numérique de la tension
    Uc0 = Uc_NUM0 * 3.3 / 1023 # Conversion en Volt (10 bits soit 1024 valeurs sur 3.3V)
    print('Uc0 =', round(Uc0,2), 'V') # Affiche la tension arrondie
    # ========= FIN DE LA MESURE ET DE L'AFFICHAGE DE LA TENSION ===========

    # ====== TEST DE CONTACT DU DOIGT AVEC UNE SURFACE ELEMENTAIRE ======
    if Uc0 < 2:
        A0 = 'x'
    else:
        A0 = ' '
    # === FIN DU TEST DE CONTACT DU DOIGT AVEC UNE SURFACE ELEMENTAIRE ===


    # ===== AFFICHAGE DE(S) POSITIONS(S) DE(S) DOIGT(S) SUR L'ECRAN =====
    # NE PAS MODIFIER LES PARTIES CI-DESSOUS
    print('    | 0 | 1 |')
    print('| A |', A0, '|', A1, '|')
    print('| B |', B0, '|', B1, '|')
    print('---------------')
    # FIN DE L'AFFICHAGE DE(S) POSITIONS(S) DE(S) DOIGT(S) SUR L'ECRAN

    sleep(Te) # Fait une pause de durée Te
