# ACQUISITION DE LA TENSION AU COURS DU TEMPS

from microbit import *

Te = 1000  # Période d'echantillonnage en millisecondes
duree = 90  # Durée de l'acquisition en seconde

tempsZero = running_time()  # Temps initial exprimé en millisecondes
t = 0  # Initialise la variable temps à zéro
print("t(s)", "\t", "Uc(V)")

while (
    t <= duree
):  # L'acquisition se poursuit tant que le temps écoulé est < ou = à la durée d'acquisition
    t = (running_time() - tempsZero) / 1000  # Calcule le temps écoulé, en secondes
    Uc_NUM = pin0.read_analog()  # Lis la valeur numérique de la tension
    Uc = Uc_NUM * 3.3 / 1023  # Conversion en Volt (10 bits soit 1024 valeurs sur 3.3V)
    print(
        t, "\t", Uc
    )  # Affiche les grandeurs mesurées séparées par une tabulation '\t'
    sleep(Te)  # Fait une pause de durée Te
