/* PROGRAMME DE COMMANDE DU MICROCONTROLEUR */

const int Te = 1000; // Période d'echantillonnage en millisecondes

int Uc_NUM0;  // Valeur numérique de la tension
float Uc0;    // Valeur analogique de Uc0

int Uc_NUM1;  // Valeur numérique de la tension
float Uc1;    // Valeur analogique de Uc1

char C0 = ' '; // Initialement la surface n'est pas en contact du doigt
char C1 = ' ';
char C2 = ' ';
char C3 = ' ';

void setup()
{
  Serial.begin(9600);
  pinMode(A0, INPUT);
  pinMode(A1, INPUT);
}
   
void loop()
{
      // ================ MESURE ET AFFICHAGE DE LA TENSION ================
      Uc_NUM0 = analogRead(A0);  // Lis la valeur numérique de la tension
      Uc0 = Uc_NUM0 * 5.0 / 1023;  // Conversion en Volt (10 bits soit 1024 valeurs sur 5V)
      Serial.print("Uc0 = ");
      Serial.print(Uc0);  // Affiche la tension 
      Serial.println("V");
      // =========== FIN DE LA MESURE ET AFFICHAGE DE LA TENSION =============
      
      // ====== TEST DE CONTACT DU DOIGT AVEC UNE SURFACE ELEMENTAIRE ======
      if (Uc0 < 3) { C0 = 'x'; }
      else  { C0 = ' '; }
      // === FIN DU TEST DE CONTACT DU DOIGT AVEC UNE SURFACE ELEMENTAIRE ===


      // ===== AFFICHAGE DE(S) POSITIONS(S) DE(S) DOIGT(S) SUR L'ECRAN =====
      // NE PAS MODIFIER LES PARTIES CI-DESSOUS
      Serial.println("    | 0 | 1 |");
      Serial.print("| A | ");
      Serial.print(C0);
      Serial.print(" | ");
      Serial.print(C1);
      Serial.println(" |");
      Serial.print("| B | ");
      Serial.print(C2);
      Serial.print(" | ");
      Serial.print(C3);
      Serial.println(" |");
      Serial.println("---------------");
      // FIN DE L'AFFICHAGE DE(S) POSITIONS(S) DE(S) DOIGT(S) SUR L'ECRAN
      
      delay(Te); // Fait une pause de durée Te
}
