/* ACQUISITION DE LA TENSION AU COURS DU TEMPS */

const int Te = 1000; // Période d'echantillonnage en millisecondes
const int duree = 90; // Durée de l'acquisition en seconde

int Uc_NUM;  // Valeur numérique de la tension Uc
float Uc;    // Valeur analogique de Uc

unsigned long tempsZero;
unsigned long t;

void setup()
{
  Serial.begin(9600);
  Serial.print("t(s)"); // Affiche dans le moniteur série l'intitulé des colonnes
  Serial.print('\t'); // Insère une tabulation
  Serial.println("Uc(V)");
  pinMode(A0, INPUT);
  tempsZero = millis(); // Temps initial exprimé en millisecondes
  t = 0; // Initialise la variable temps à zéro
}
   
void loop()
{
  while (t/1000.0<=duree) // L'acquisition se poursuit tant que le temps écoulé est < ou = à la durée d'acquisition
  {
      t = millis()-tempsZero; // Calcule le temps écoulé, en millisecondes
      Uc_NUM = analogRead(A0);  // Lis la valeur numérique de la tension
      Uc = Uc_NUM * 5.0 / 1023 ;  // Conversion en Volt (10 bits soit 1024 valeurs sur 5V)
      Serial.print(t/1000.0); // Affiche dans le moniteur série les grandeurs mesurées séparées par une tabulation
      Serial.print('\t');  // Insère une tabulation
      Serial.println(Uc);
      delay(Te); // Fait une pause de durée Te
  }
}
