# Modélisation d'un générateur d'impulsions

from microbit import *
Te = 10 # Période d'echantillonnage en millisecondes
duree = 5 # Durée de l'acquisition en seconde

tempsZero = running_time() # Temps initial exprimé en millisecondes
temps = 0 # Initialise la variable temps à zéro
Uc = 0 # Initialise la variable Uc à zéro
print ("t(s)", '\t', "Uc(V)")

while (temps <= duree): # L'acquisition se poursuit tant que le temps écoulé est < ou = à la durée d'acquisition

    # =================== CHARGE DU CONDENSATEUR ===================
    pin1.set_pull(pin1.NO_PULL) # La branche contenant "R" est "déconnectée"
    pin2.write_digital(1)  # La branche contenant "r" est "connectée", la broche 2 est mise à 3.3V et "C" se charge à travers "r"

    while (Uc <= 3.2): # Avec ce paramétrage et compte-tenu de l'échantillonnage, l'étape de charge se termine effectivement à 3.3V
        temps = (running_time() - tempsZero)/1000 # Calcule le temps écoulé, en secondes
        Uc_NUM = pin0.read_analog() # Lis la valeur numérique de Uc sur la broche 0
        Uc = Uc_NUM * 3.3 / 1023 # Conversion de Uc_NUM en Uc (10 bits soit 1024 valeurs sur 3.3V)
        print(temps, '\t', Uc) # Affiche le temps et Uc séparés par une tabulation
        sleep(Te) # Fait une pause de durée Te
    # ============== FIN DE LA CHARGE DU CONDENSATEUR ==============

    # ================== DÉCHARGE DU CONDENSATEUR ==================
    pin2.set_pull(pin2.NO_PULL) # La branche contenant "r" est "déconnectée"
    pin1.write_digital(0)  # La branche contenant "R" est "connectée", la broche 1 est mise à 0V et "C" se décharge à travers "R"

    while (Uc >= 2.0): # L'étape de décharge se termine lorsque Uc atteint la valeur en Volt indiquée après les symboles >=
        temps = (running_time() - tempsZero)/1000 # Calcule le temps écoulé, en secondes
        Uc_NUM = pin0.read_analog() # Lis la valeur numérique de Uc sur la broche 0
        Uc = Uc_NUM * 3.3 / 1023 # Conversion de Uc_NUM en Uc (10 bits soit 1024 valeurs sur 3.3V)
        print(temps, '\t', Uc) # Affiche le temps et Uc séparés par une tabulation
        sleep(Te) # Fait une pause de durée Te
    # ============== FIN DE LA DÉCHARGE DU CONDENSATEUR ============
