// définition des différentes grandeurs
float temps;
float temps_0;
int Uc_NUM;  // Valeur numérique de la tension Uc aux bornes du condensateur 
float Uc, E;    // Valeur analogique de Uc

void setup() {
  Serial.begin(9600);
  pinMode(A0, INPUT);
  
  // Charge rapide du condensateur
  pinMode(3, OUTPUT);
  digitalWrite(3, HIGH);
  delay(1000);
  pinMode(3, INPUT);

  temps_0 = millis(); // ms
  E = 5.0; // tension inititale aux bornes du condensateur (5V)

  // Décharge du condensateur
  Serial.println("Décharge du condensateur et mesure de tau, patientez...");
  Uc = E;
  
  while (Uc >      ) { // LIGNE A MODIFIER
    // Boucle fonctionnant comme une zone d'attente,
    // On sort de la boucle lorsque tau est atteint.
    Uc_NUM = analogRead(A0);  // Lis la valeur numérique de Uc sur A0
    Uc = Uc_NUM * 5.0 / 1023 ;  // Conversion de Uc_NUM en Uc (10 bits soit 1024 valeurs sur 5V)
    temps = float((millis() - temps_0) / 1000);
    
    Serial.print("t(s) : ");
    Serial.print(temps);
    Serial.print('\t');  // Insère une tabulation
    Serial.print("Uc(V) : ");
    Serial.println(Uc);
    delay(1000);
  }

  Serial.print("Constante de temps tau = ");
  Serial.print(temps);
  Serial.println(" s");
}




void loop() {
}
