# -*- coding: utf-8 -*-
"""
Détermination de la viscosité et de l'incertitude-type associée u(viscosité)

"""

import numpy as np

###############################################################################
####                    Partie à modifier                                  ####
###############################################################################
# masse volumique de la bille en acier
rho_acier = 1*10**3 # A MODIFIER : masse volumique de l'acier (en kg/m³)

# masse volumique du fluide 
rho_fluide = 1      # A MODIFIER : masse volumique du fluide (en kg/m³)

V = 1               # A MODIFIER : volume du fluide (en mL)
t = 1               # A MODIFIER : tolérance de la burette (en mL)
u_V = t/np.sqrt(3)  # incertitude-type sur le volume du fluide (en mL)

m = 1               # A MODIFIER : masse du fluide (en g)
a = 1               # A MODIFIER : précision de la balance (en 1/100 de g)
u_m = a/np.sqrt(3)  # incertitude-type sur la masse du fluide (en g)

# Mesure du diamètre D avec le pied à coulisse
D =   1*10**-2      # A MODIFIER : mesure de D (en mètre)
d  = 0.1*10**-2     # A MODIFIER : plus petite graduation du pied à coulisse (en mètre)
u_D = d/np.sqrt(12) # incertitude-type sur la mesure de D (mètre)

# vitessse limite et incertitude-type associée
v_lim = 1.          # A MODIFIER vitesse limite ( en m/s)
u_v_lim = 0.1       # A MODIFIER incertitude-type associée à la vitesse limite (en m/s)

###############################################################################
####        Ne pas modifier la suite de ce programme                       ####
###############################################################################
g= 9.81 # intensité de pesanteur (en m/s²)
viscosite = (rho_acier - rho_fluide)*g*D**2/(18*v_lim)
u_viscosite=viscosite*np.sqrt( ( (u_V/V)**2 + (u_m/m)**2 )*(rho_fluide/(rho_acier - rho_fluide))**2 + 4*(u_D/D)**2 + (u_v_lim/v_lim)**2)
print("Valeur de la viscosité (Pa.s) : viscosité =", viscosite)
print("Incertitude-type composée associée à la viscosité (Pa.s) : u(viscosité) =",u_viscosite)
