#!/usr/bin/env python
# coding: utf-8

# # Interférences
# ## Somme de deux signaux sinusoïdaux synchrones


# Import des bibliothèques

import numpy as np
import matplotlib.pyplot as plt


# Fonction de calcul de la somme de deux signaux sinusoïdaux
def onderesultante(A1, A2, T, phi,duree,Te):
    t=np.arange(0,duree,Te)
    s1= A1*np.cos(2*np.pi*t/T)      # on pose phi1=0
    s2= A2*np.cos(2*np.pi*t/T+phi )
    s=s1+s2

    plt.figure (figsize = (10,8))
    plt.plot(t,s1,"ro-",label="onde 1")
    plt.plot(t,s2,"b+-",label="onde 2")
    plt.plot(t,s,"g+-",label="onde résultante")
    plt.xlabel("temps(µs)")
    plt.ylabel("élongation")
    plt.legend()
    plt.grid()
    plt.title ("Interférences de deux ondes")
    plt.show()


# Paramètres
############################################### partie à modifier

phi = 1.2*np.pi   # np.pi représente pi

###############################################

A1=1
A2=1
T=25   # période en µs
duree= 75   # durée du signal en µs
Te= 0.5   # durée entre deux points en µs

onderesultante(A1,A2,T,phi,duree,Te)






