#!/usr/bin/env python
# -*- coding: utf-8 -*-

import matplotlib.pyplot as plt
import csv

#######################################################################################################################################
########################## IMPORTATION DES DONNEES D'UN FICHIER CSV ##########################################
#######################################################################################################################################

fichier = "lancer_2.csv" # Nom du fichier contenant les données de la vidéo
separateur = ";"
colonne_t = 0
colonne_y = 2

fichierCSV = open(fichier, encoding="UTF8")

contenu = csv.reader(fichierCSV, delimiter=separateur)
tableau = list(contenu)
nombreLignes=len(tableau)

t = []
y = []

for i in range(2,nombreLignes):
    ligne = tableau[i]
    t_valeur = float(ligne[colonne_t].replace(',','.'))
    y_valeur = float(ligne[colonne_y].replace(',','.'))
    t.append(t_valeur)
    y.append(y_valeur)

fichierCSV.close()

#######################################################################################################################################
############################## TRAITEMENT DES DONNEES #################################################################################
#######################################################################################################################################


N = len(y) # Nombre de points

# Initialisation des listes à la valeur 0
vy = [0 for i in range(N)] # Liste des vy avec N élements à 0
Ec = [0 for i in range(N)] # Liste des Ec avec N élements à 0
Ep = [0 for i in range(N)] # Liste des Ep avec N élements à 0

# Définitions des valeurs
g = 9.8 # Valeur de l'intensité de la pesanteur, en N.kg-1
m = 0.058 # Valeur de la masse de la balle, en kg

#######################################################################################################################################
############################################################ PARTIE A COMPLETER PAR LE CANDIDAT  #####################################################
#######################################################################################################################################

# Candidat - remplissage des listes
for i in range(1, N-1) :
    vy[i] = (y[i+1]-y[i-1])/(t[i+1]-t[i-1])
    Ep[i] = m*g*y[i]
    Ec[i] = # à compléter

# Supprimer le premier et le dernier élément non utilisés des listes des énergies
Ec.pop(0) # premier
Ep.pop(0) # premier
Ec.pop() # dernier
Ep.pop() # dernier

# Supprimer le premier et le dernier élément de la liste temporelle pour que toutes les listes aient la même taille
t.pop(0) # premier
t.pop() # dernier


# Candidat - tracé des graphiques

# Graphique
plt.clf()
plt.grid()
plt.title("Evolution temporelle des énergies")

plt.xlabel("Temps t, en s")
plt.ylabel("Energie, en J")

plt.plot(t,Ep,"b-",label="Energie potentielle")
# à compléter pour tracer la courbe de l'énergie cinétique



plt.legend()
plt.show()








