﻿# -*- coding: utf-8 -*-
###############################################################################
####                         Qr à l'équilibre
###############################################################################
import numpy as np
import matplotlib.pyplot as plt

###############################################################################
#####                   Partie du programme A MODIFIER
###############################################################################

# concentration de la solution aqueuse et incertitude-type associée
C = 1        # A MODIFIER ; concentration molaire de C
u_C = 0.1     # A MODIFIER  ; incertitude-type de C 

# valeur de la conductivité et de son incertitude-type
sigma = 1     # A MODIFIER  ; conductivité de la solution
usigma = 0.1   # A MODIFIER  ; incertitude-type de la conductivité 

###############################################################################
#####               Ne pas modifier la suite de ce programme
###############################################################################

# Constantes
N = 10**5 # nombre de tirages aléatoires
# Conductivités molaires ioniques
l_1 = 4.1e-3 # ion méthanoate (unité S.I.)
l_2 = 3.5e-2 # ion oxonium (unité S.I.)
pKa_ref = 3.75 # valeur de référence du pKadu couple à 25 °C

# Méthode numérique de type Monte Carlo : détermination de Q_r,eq , pKa et u(pKa)

# Déclaration de la liste
pKa_list=[]

# tirage aléatoire des valeurs de Q_r,eq et du pKa
for i in range(N):
    valeur_sigma = np.random.normal(sigma,usigma)
    valeur_C = np.random.normal(C,u_C)
    valeur_Qr_eq=valeur_sigma**2/(1000*(l_1+l_2)**2*(1000*valeur_C-valeur_sigma/(l_1+l_2)))     
    pKa_list.append(-np.log10(valeur_Qr_eq)) 

# histogramme : distribution des valeurs du pKa
plt.figure()
plt.title("Simulation de la distribution des valeurs du $pK_{a}$ \n Méthode numérique de type Monte-Carlo",fontsize=15)
plt.hist(pKa_list,bins=200)
plt.grid()
plt.show()

# Calcul de la valeur moyenne du pKa et de u(pKa)
moy_pKa = np.mean(pKa_list)
upKa = np.std(pKa_list,ddof=1)

# valeurs numériques
print("----------------------------------------------------------------------")
print('pKa = ', '{:.2f}'.format(moy_pKa))
print('u(pKa) = ', '{:.2f}'.format(upKa))
print('pKa_ref = ', '{:.2f}'.format(pKa_ref))
print("----------------------------------------------------------------------")
